/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.DictionaryEditorShell;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import net.nooj4nlp.controller.DictionaryDialog.DictionaryDialogController;
import net.nooj4nlp.engine.ComplexDictionaryParser;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.DicInvItemComparer;
import net.nooj4nlp.engine.DicItemComparer;
import net.nooj4nlp.engine.DictionaryParser;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.ParsingException;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.Property;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.FindReplaceDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.ErrorShell;
import org.apache.commons.io.FilenameUtils;

public class DictionaryEditorShellController {
    private String fullName;
    private Language lan;
    private static JTextPane textPane;
    private HashMap<String, Boolean> prop_inf;
    private HashMap<String, Boolean> prop_cat;
    private HashMap<String, String> properties;
    private boolean modified;
    private DictionaryEditorShell shell;
    private JLabel lblnTus;
    private ErrorShell errorShell;
    private FindReplaceDialog findReplaceDialog;
    private static DicItemComparer dicComparer;
    private static DicInvItemComparer dicInvComparer;
    private JPanel editorPane;
    private JPanel tablePane;
    private JTable table;
    private JScrollPane tableContainer;
    private static Comparator<String> comparator;
    private static Comparator<String> comparatorInv;

    public DictionaryEditorShellController(JTextPane textPane, DictionaryEditorShell shell, JLabel lblnTus, JPanel editorPane, JPanel tablePane, JTable table, JScrollPane tableContainer) {
        DictionaryEditorShellController.textPane = textPane;
        this.shell = shell;
        this.lblnTus = lblnTus;
        this.errorShell = new ErrorShell();
        this.editorPane = editorPane;
        this.tablePane = tablePane;
        this.table = table;
        this.tableContainer = tableContainer;
        this.findReplaceDialog = null;
        comparator = new Comparator<String>(){

            @Override
            public int compare(String x, String y) {
                return DictionaryEditorShellController.this.lan.sortTexts(x, y, false);
            }
        };
        comparatorInv = new Comparator<String>(){

            @Override
            public int compare(String x, String y) {
                int i;
                StringBuilder tmp1 = new StringBuilder();
                StringBuilder tmp2 = new StringBuilder();
                for (i = x.length() - 1; i >= 0; --i) {
                    tmp1.append(x.charAt(i));
                }
                for (i = y.length() - 1; i >= 0; --i) {
                    tmp2.append(y.charAt(i));
                }
                return DictionaryEditorShellController.this.lan.sortTexts(tmp1.toString(), tmp2.toString(), false);
            }
        };
    }

    public static DictionaryEditorShell openNooJDictionary(String fullname) {
        DictionaryEditorShell editor = null;
        try {
            CursorChangeEffect.setCustomCursor(3);
            editor = new DictionaryEditorShell();
            editor.getController().loadFromFile(fullname);
            Launcher.getDesktopPane().add(editor);
            editor.setVisible(true);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
        return editor;
    }

    public static String getLanguage() {
        String line;
        Document document = textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() == 0) {
            return null;
        }
        Element lineElem = rootElem.getElement(3);
        int lineStart = lineElem.getStartOffset();
        int lineEnd = lineElem.getEndOffset();
        try {
            line = document.getText(lineStart, lineEnd - lineStart).trim();
        }
        catch (BadLocationException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            return null;
        }
        if (line.length() >= 23) {
            return line.substring(21);
        }
        return null;
    }

    public static String buildHeader(String isoname) {
        StringBuilder sb = new StringBuilder();
        sb.append("# NooJ V4\n");
        sb.append("# Dictionary\n");
        sb.append("#\n");
        sb.append("# Input Language is: " + isoname + "\n");
        sb.append("#\n");
        sb.append("# Alphabetical order is not required.\n");
        sb.append("#\n");
        sb.append("# Use inflectional & derivational paradigms' description files (.nof), e.g.:\n");
        sb.append("# Special Command: #use paradigms.nof\n");
        sb.append("#\n");
        sb.append("# Special Features: +NW (non-word) +FXC (frozen expression component) +UNAMB (unambiguous lexical entry)\n");
        sb.append("#                   +FLX= (inflectional paradigm) +DRV= (derivational paradigm)\n");
        sb.append("#\n");
        sb.append("# Special Characters: '\\' '\"' '+' ',' '#' ' '\n");
        sb.append("#\n");
        return sb.toString();
    }

    public static int sizeOfHeader() {
        String header = DictionaryEditorShellController.buildHeader("en");
        return header.length();
    }

    public void initLoad(String l) {
        textPane.setText(DictionaryEditorShellController.buildHeader(l));
        this.lan = new Language(l);
        this.lblnTus.setText("Dictionary contains " + Integer.toString(DictionaryDialogController.count(textPane)) + " entries");
    }

    private boolean checkHeader() {
        Document document = textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() == 0) {
            return false;
        }
        block8: for (int i = 0; i < 4; ++i) {
            String lineText;
            Element lineElem = rootElem.getElement(i);
            if (lineElem == null) {
                return false;
            }
            int lineStart = lineElem.getStartOffset();
            int lineEnd = lineElem.getEndOffset();
            try {
                lineText = document.getText(lineStart, lineEnd - lineStart).trim();
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return false;
            }
            switch (i) {
                case 0: {
                    if (lineText.equals("# NooJ V1") || lineText.equals("# NooJ V2") || lineText.equals("# NooJ V3") || lineText.equals("# NooJ V4")) continue block8;
                    return false;
                }
                case 1: {
                    if (lineText.equals("# Dictionary")) continue block8;
                    return false;
                }
                case 2: {
                    if (lineText.equals("#")) continue block8;
                    return false;
                }
                case 3: {
                    if (lineText.substring(0, 21).equals("# Input Language is: ")) continue block8;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean loadCategoryPropertiesFeatures(String propertydefinitionfile, RefObject<String> errmessageRef) {
        this.prop_cat = null;
        this.prop_inf = null;
        this.properties = null;
        errmessageRef.argvalue = null;
        File file = new File(propertydefinitionfile);
        if (!file.exists()) {
            errmessageRef.argvalue = "Cannot find Property Definition File: " + propertydefinitionfile;
            Dic.writeLog((String)errmessageRef.argvalue);
            return false;
        }
        BufferedReader sr = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(propertydefinitionfile), "UTF8"));
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while encoding! Unsupported encoding!", 0);
        }
        try {
            String header = sr.readLine();
            if (!(header.equals("# NooJ V1") || header.equals("# NooJ V2") || header.equals("# NooJ V3") || header.equals("# NooJ V4"))) {
                errmessageRef.argvalue = "Property Definition File Format is invalid in " + propertydefinitionfile;
                Dic.writeLog((String)errmessageRef.argvalue);
                sr.close();
                return false;
            }
            StringBuilder builder = new StringBuilder();
            String line0 = sr.readLine();
            while (line0 != null) {
                builder.append(line0 + "\n");
                line0 = sr.readLine();
            }
            String rawbuf = builder.toString();
            sr.close();
            String buf = Dic.noComment(rawbuf);
            int ibuf = 0;
            while (ibuf < buf.length()) {
                int ifeat;
                String category = null;
                String property = null;
                String[] features = null;
                RefObject<Object> categoryRef = new RefObject<Object>(category);
                RefObject<Object> propertyRef = new RefObject<Object>(property);
                RefObject<Object> featuresRef = new RefObject<Object>(features);
                int end = Dic.getRule(buf, ibuf, categoryRef, propertyRef, featuresRef, errmessageRef);
                category = (String)categoryRef.argvalue;
                property = (String)propertyRef.argvalue;
                features = (String[])featuresRef.argvalue;
                if (end == -1) {
                    if (errmessageRef.argvalue != null) {
                        sr.close();
                        return false;
                    }
                    break;
                }
                if (category.equals("INFLECTION")) {
                    if (this.prop_inf == null) {
                        this.prop_inf = new HashMap();
                    }
                    for (ifeat = 0; ifeat < features.length; ++ifeat) {
                        if (this.prop_inf.containsKey(features[ifeat])) continue;
                        this.prop_inf.put(features[ifeat], true);
                    }
                } else {
                    if (this.prop_cat == null) {
                        this.prop_cat = new HashMap();
                    }
                    if (!this.prop_cat.containsKey(category + "_" + property)) {
                        this.prop_cat.put(category + "_" + property, true);
                    }
                    for (ifeat = 0; ifeat < features.length; ++ifeat) {
                        String ncat;
                        if (this.properties == null) {
                            this.properties = new HashMap();
                        }
                        if (this.properties.containsKey(ncat = category + "_" + features[ifeat])) continue;
                        this.properties.put(ncat, property);
                    }
                }
                ibuf = end;
            }
        }
        catch (IOException e) {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean relevantProperty(String category, String property) {
        if (this.prop_cat == null) {
            return true;
        }
        return this.prop_cat.containsKey(category + "_" + property);
    }

    private boolean loadPropertiesDefinition() {
        String errmessage;
        RefObject<Object> errmessageRef;
        String dname = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.lan.isoName, "Lexical Analysis"));
        String pname = FilenameUtils.concat(dname, "_properties.def");
        if (!this.loadCategoryPropertiesFeatures(pname, errmessageRef = new RefObject<Object>((errmessage = null)))) {
            errmessage = (String)errmessageRef.argvalue;
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Warning: " + errmessage, "NooJ WARNING", 1);
            return false;
        }
        return true;
    }

    public boolean loadFromFile(String fn) {
        this.fullName = fn;
        BufferedReader sr = null;
        StringBuilder builder = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fn), "UTF8"));
        }
        catch (FileNotFoundException e) {
            if (fn.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Filename cannot be empty!", "NooJ", 1);
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File \"" + fn + "\" not found!", "NooJ", 1);
            }
            return false;
        }
        catch (UnsupportedEncodingException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while encoding! Unsupported encoding!", 0);
        }
        try {
            builder = new StringBuilder();
            String line0 = sr.readLine();
            while (line0 != null) {
                builder.append(line0);
                builder.append("\n");
                line0 = sr.readLine();
            }
            textPane.setText(builder.toString());
            sr.close();
        }
        catch (IOException e) {
            try {
                sr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: Cannot load file " + fn, "NooJ", 1);
            return false;
        }
        if (!this.checkHeader()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load NooJ Dictionary " + fn, "NooJ [.dic Header Format Error]", 1);
            textPane.setText("");
            return false;
        }
        String languagename = DictionaryEditorShellController.getLanguage();
        if (languagename == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load NooJ Dictionary " + fn, "NooJ [.dic Header Format Error]", 1);
            textPane.setText("");
            return false;
        }
        this.lan = new Language(languagename);
        if (this.lan.rightToLeft) {
            this.tableContainer.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.table.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.modified = false;
        this.shell.setTitle(FilenameUtils.getName(this.fullName));
        this.lblnTus.setText("Dictionary contains " + Integer.toString(DictionaryDialogController.count(textPane)) + " entries");
        textPane.select(0, 0);
        if (!this.check()) {
            Launcher.getDesktopPane().add(this.errorShell);
            this.errorShell.setVisible(true);
        }
        return true;
    }

    public boolean loadFromDl(String fullname, String lang, Charset enc, boolean delas) {
        this.lan = new Language(lang);
        if (this.lan == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Language error", "NooJ", 1);
            return false;
        }
        BufferedReader sr = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fullName), enc));
            this.errorShell.getTxtError().setText("");
            this.initLoad(lang);
            StringBuilder text = new StringBuilder();
            int nboferrors = 0;
            String line = sr.readLine();
            while (line != null) {
                String errormessage = null;
                RefObject<Object> errormessageRef = new RefObject<Object>(errormessage);
                String[] lines = null;
                lines = delas ? Dic.convertFromDls(line, errormessageRef) : Dic.convertFromDlf(line, errormessageRef);
                errormessage = (String)errormessageRef.argvalue;
                if (lines == null) {
                    if (delas) {
                        this.errorShell.getTxtError().append("* DELAS FORMAT ERROR: " + line + "\n");
                    } else {
                        this.errorShell.getTxtError().append("* DELAF FORMAT ERROR: " + line + "\n");
                    }
                    if (++nboferrors >= 100) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Too many format errors", "NooJ: format is probably not DELAS", 0);
                        Launcher.getDesktopPane().add(this.errorShell);
                        this.errorShell.setVisible(true);
                        break;
                    }
                } else {
                    for (int i = 0; i < lines.length; ++i) {
                        text.append(lines[i]);
                        text.append("\n");
                    }
                }
                line = sr.readLine();
            }
            textPane.setText(textPane.getText() + text.toString());
            sr.close();
        }
        catch (Exception e) {
            try {
                sr.close();
            }
            catch (IOException line) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot open dictionary file", "NooJ: file " + fullname + " is protected or locked", 1);
            return false;
        }
        String fname = FilenameUtils.getBaseName(fullname) + ".dic";
        String dname = FilenameUtils.getFullPath(fullname);
        this.fullName = FilenameUtils.concat(dname, fname);
        textPane.setFocusable(true);
        this.modify();
        if (!this.errorShell.getTxtError().getText().equals("")) {
            Launcher.getDesktopPane().add(this.errorShell);
            this.errorShell.setVisible(true);
        }
        return true;
    }

    public void modify() {
        if (Launcher.projectMode) {
            return;
        }
        if (this.modified) {
            return;
        }
        this.modified = true;
        if (this.fullName == null) {
            this.shell.setTitle("Untitled [Modified]");
        } else {
            this.shell.setTitle(FilenameUtils.getName(this.fullName) + " [Modified]");
        }
        this.lblnTus.setText("");
    }

    public void save() {
        if (this.fullName == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot save dictionary", "NooJ: undefined file name", 1);
            return;
        }
        this.save(this.fullName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String fullname, boolean forNooJ) {
        String fname;
        if (!forNooJ && (fname = FilenameUtils.getName(fullname)).charAt(0) == '_' && JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "WARNING: file name starts with \"_\". Are you sure you want to save it with this prefix?", "NooJ: protected resource", 0) != 0) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullname), "UTF8"));
            writer.write(textPane.getText());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: cannot save dictionary", "NooJ", 0);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (!forNooJ) {
            this.fullName = fullname;
        }
        this.modified = false;
        this.shell.setTitle(FilenameUtils.getName(this.fullName));
        this.lblnTus.setText("Dictionary contains " + Integer.toString(DictionaryDialogController.count(textPane)) + " entries");
    }

    public void saveDictionary() {
        if (this.fullName == null) {
            this.saveAsDictionary();
        } else {
            try {
                CursorChangeEffect.setCustomCursor(3);
                this.save();
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsDictionary() {
        File directory = new File(FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.lan.isoName, "Lexical Analysis")));
        JFileChooser chooser = Launcher.getSaveDicChooser();
        chooser.setCurrentDirectory(directory);
        if (chooser.showSaveDialog(this.shell) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        Launcher.getOpenDicChooser().setCurrentDirectory(file);
        chooser.setCurrentDirectory(file);
        String fileStr = file.getAbsolutePath();
        if (!fileStr.endsWith(".dic")) {
            fileStr = fileStr + ".dic";
        }
        try {
            CursorChangeEffect.setCustomCursor(3);
            this.save(fileStr, false);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDictionaryForNooJ() {
        String languagename = this.lan.isoName;
        String dirname = FilenameUtils.concat(FilenameUtils.concat(Paths.applicationDir, "resources"), FilenameUtils.concat("initial", FilenameUtils.concat(languagename, "Lexical Analysis")));
        String fname = FilenameUtils.getName(this.fullName);
        String noojname = FilenameUtils.concat(dirname, fname);
        try {
            CursorChangeEffect.setCustomCursor(3);
            this.save(noojname, true);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File " + noojname + " has been updated.", "NooJ Update", 1);
    }

    public boolean check() {
        int cpt = 0;
        Document document = textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        for (int i = 0; i < rootElem.getElementCount(); ++i) {
            String lineText;
            Element lineElem = rootElem.getElement(i);
            int lineStart = lineElem.getStartOffset();
            int lineEnd = lineElem.getEndOffset();
            try {
                lineText = document.getText(lineStart, lineEnd - lineStart).trim();
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return false;
            }
            if (lineText.equals("")) continue;
            String entry = null;
            String lemma = null;
            String category = null;
            String[] properties = null;
            Integer[] indices = null;
            Property[] features = null;
            RefObject<Object> entryRef = new RefObject<Object>(entry);
            RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
            RefObject<Object> categoryRef = new RefObject<Object>(category);
            RefObject<Object> propertiesRef = new RefObject<Object>(properties);
            try {
                DictionaryParser.parse(lineText, entryRef, lemmaRef, categoryRef, propertiesRef, indices, features);
                entry = (String)entryRef.argvalue;
                lemma = (String)lemmaRef.argvalue;
                category = (String)categoryRef.argvalue;
                properties = (String[])propertiesRef.argvalue;
            }
            catch (ParsingException ex) {
                String entry1 = null;
                String[] lexeme1 = null;
                Integer[] indices1 = null;
                String[] properties1 = null;
                Property[] features1 = null;
                RefObject<Object> entry1Ref = new RefObject<Object>(entry1);
                RefObject<Object> lexeme1Ref = new RefObject<Object>(lexeme1);
                RefObject<Object> properties1Ref = new RefObject<Object>(properties1);
                try {
                    if (ComplexDictionaryParser.parse(lineText, entry1Ref, lexeme1Ref, properties1Ref, indices1, features1)) {
                        entry1 = (String)entry1Ref.argvalue;
                        lexeme1 = (String[])lexeme1Ref.argvalue;
                        properties1 = (String[])properties1Ref.argvalue;
                        for (int j = 0; j < lexeme1.length; ++j) {
                            String entry2 = null;
                            String lemma2 = null;
                            String category2 = null;
                            String[] properties2 = null;
                            Integer[] indices2 = null;
                            Property[] features2 = null;
                            RefObject<Object> entry2Ref = new RefObject<Object>(entry2);
                            RefObject<Object> lemma2Ref = new RefObject<Object>(lemma2);
                            RefObject<Object> category2Ref = new RefObject<Object>(category2);
                            RefObject<Object> properties2Ref = new RefObject<Object>(properties2);
                            try {
                                DictionaryParser.parse(lexeme1[j], entry2Ref, lemma2Ref, category2Ref, properties2Ref, indices2, features2);
                                entry2 = (String)entry2Ref.argvalue;
                                lemma2 = (String)lemma2Ref.argvalue;
                                category2 = (String)category2Ref.argvalue;
                                properties2 = (String[])properties2Ref.argvalue;
                                continue;
                            }
                            catch (ParsingException ex1) {
                                ++cpt;
                                StringBuilder s = new StringBuilder("At character ");
                                int endOfNumber = ex.message.indexOf(58);
                                Integer.parseInt(ex.message.substring(13, endOfNumber));
                                s.append(ex.message.substring(endOfNumber));
                                this.errorShell.getTxtError().append("Line " + Integer.valueOf(i + 1).toString() + " " + ex1.message.toLowerCase() + "\n");
                            }
                        }
                    } else {
                        ++cpt;
                        this.errorShell.getTxtError().append("Line " + Integer.valueOf(i + 1).toString() + " " + ex.message.toLowerCase() + "\n");
                    }
                }
                catch (ParsingException e) {
                    ++cpt;
                    this.errorShell.getTxtError().append("Line " + Integer.valueOf(i + 1).toString() + " " + e.message.toLowerCase() + "\n");
                }
            }
            if (cpt <= 1000) continue;
            return false;
        }
        if (cpt == 0) {
            this.lblnTus.setText("Dictionary contains " + Integer.toString(DictionaryDialogController.count(textPane)) + " entries");
        }
        return cpt == 0;
    }

    public static void sortLines(ArrayList<String> lines, Language lan) {
        if (dicComparer == null) {
            dicComparer = new DicItemComparer(lan);
        }
        Collections.sort(lines, dicComparer);
        String previousline = "";
        int i = 0;
        while (i < lines.size()) {
            if (previousline.equals(lines.get(i))) {
                lines.remove(i);
                continue;
            }
            previousline = lines.get(i);
            ++i;
        }
    }

    private static void sortInvLines(ArrayList<String> lines, Language lan) {
        if (dicInvComparer == null) {
            dicInvComparer = new DicInvItemComparer(lan);
        }
        Collections.sort(lines, dicInvComparer);
        String previousline = "";
        int i = 0;
        while (i < lines.size()) {
            if (previousline.equals(lines.get(i))) {
                lines.remove(i);
                continue;
            }
            previousline = lines.get(i);
            ++i;
        }
    }

    public void sortDictionary(boolean standardmode) {
        ArrayList<String> lines = new ArrayList<String>();
        String rtbtext = textPane.getText();
        String sep = "\n";
        String[] rtblines = rtbtext.split(sep);
        int iline = 0;
        while (iline < rtblines.length) {
            String line = rtblines[iline];
            while (line.length() == 0 || line.charAt(0) == '#') {
                lines.add(line);
                if (++iline >= rtblines.length) break;
                line = rtblines[iline];
            }
            ArrayList<String> lines0 = new ArrayList<String>();
            while (line.length() > 0 && line.charAt(0) != '#') {
                lines0.add(line);
                if (++iline >= rtblines.length) break;
                line = rtblines[iline];
            }
            if (standardmode) {
                DictionaryEditorShellController.sortLines(lines0, this.lan);
            } else {
                DictionaryEditorShellController.sortInvLines(lines0, this.lan);
            }
            lines.addAll(lines0);
        }
        StringBuilder sb = new StringBuilder();
        for (int iline2 = 0; iline2 < lines.size(); ++iline2) {
            String line = (String)lines.get(iline2);
            if (iline2 >= lines.size() - 1 && line.equals("")) continue;
            sb.append(line + "\n");
        }
        textPane.setText(sb.toString());
    }

    private ArrayList<String> computeColumns(String[] lexemes, RefObject<Boolean> thereisalemma) {
        thereisalemma.argvalue = false;
        ArrayList<String> scolumns = new ArrayList<String>();
        ArrayList<String> mcolumns = new ArrayList<String>();
        this.loadPropertiesDefinition();
        boolean thereisasynsem = false;
        for (int i = 0; i < lexemes.length; ++i) {
            String lexeme = lexemes[i].trim();
            if (lexeme.equals("") || lexeme.charAt(0) == '#') continue;
            String entry = null;
            String lemma = null;
            String category = null;
            String info = null;
            String[] features = null;
            RefObject<Object> entryRef = new RefObject<Object>(entry);
            RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
            RefObject<Object> categoryRef = new RefObject<Object>(category);
            RefObject<Object> infoRef = new RefObject<Object>(info);
            RefObject<Object> featuresRef = new RefObject<Object>(features);
            if (Dic.nbOfCommas(lexeme) == 2) {
                if (!Dic.parseDELAF(lexeme, entryRef, lemmaRef, null, categoryRef, null, featuresRef)) continue;
                entry = (String)entryRef.argvalue;
                lemma = (String)lemmaRef.argvalue;
                category = (String)categoryRef.argvalue;
                features = (String[])featuresRef.argvalue;
            } else if (Dic.parseDELASFeatureArray(lexeme, entryRef, categoryRef, featuresRef)) {
                entry = (String)entryRef.argvalue;
                category = (String)categoryRef.argvalue;
                features = (String[])featuresRef.argvalue;
                lemma = entry;
            } else {
                if (!Dic.parseContracted(lexeme, entryRef, infoRef)) continue;
                entry = (String)entryRef.argvalue;
                info = (String)infoRef.argvalue;
                category = "CONTRACTED";
                lemma = entry;
                features = new String[]{info};
            }
            if (features == null || features.length == 0) continue;
            if (lemma != null && !lemma.equals("")) {
                thereisalemma.argvalue = true;
            }
            if (features == null) continue;
            for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                String feat0 = features[ifeat];
                if (feat0.equals("")) continue;
                String propname = null;
                String propvalue = null;
                RefObject<Object> propnameRef = new RefObject<Object>(propname);
                RefObject<Object> propvalueRef = new RefObject<Object>(propvalue);
                Dic.getProperty(feat0, category, this.properties, propnameRef, propvalueRef);
                propname = (String)propnameRef.argvalue;
                propvalue = (String)propvalueRef.argvalue;
                if (feat0.equals(propname)) {
                    thereisasynsem = true;
                    continue;
                }
                int index = mcolumns.indexOf(propname);
                if (index != -1) continue;
                mcolumns.add(propname);
            }
        }
        Collections.sort(scolumns, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareToIgnoreCase(arg1);
            }
        });
        Collections.sort(mcolumns, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareToIgnoreCase(arg1);
            }
        });
        scolumns.addAll(mcolumns);
        if (thereisasynsem) {
            scolumns.add("SynSem");
        }
        return scolumns;
    }

    public void fillInLvDicos() {
        this.table.setAutoResizeMode(0);
        String[] lines = textPane.getText().split("\n");
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.setRowCount(0);
        model.setColumnCount(0);
        Boolean thereisalemma = false;
        RefObject<Boolean> thereisalemmaRef = new RefObject<Boolean>(thereisalemma);
        ArrayList<String> columns = this.computeColumns(lines, thereisalemmaRef);
        thereisalemma = (Boolean)thereisalemmaRef.argvalue;
        if (this.lan.isoName.equals("fr")) {
            model.addColumn("Entr\u00e9e");
            if (thereisalemma.booleanValue()) {
                model.addColumn("S-Lemme");
            }
            model.addColumn("Cat\u00e9gorie");
        } else {
            model.addColumn("Entry");
            if (thereisalemma.booleanValue()) {
                model.addColumn("S-Lemma");
            }
            model.addColumn("Category");
        }
        for (String prop : columns) {
            model.addColumn(prop);
        }
        for (String line : lines) {
            String lexeme = line.trim();
            if (lexeme.equals("") || lexeme.charAt(0) == '#') continue;
            String entry = null;
            String lemma = null;
            String category = null;
            String info = null;
            String[] lexfeatures = null;
            RefObject<Object> entryRef = new RefObject<Object>(entry);
            RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
            RefObject<Object> categoryRef = new RefObject<Object>(category);
            RefObject<Object> infoRef = new RefObject<Object>(info);
            RefObject<Object> lexfeaturesRef = new RefObject<Object>(lexfeatures);
            if (Dic.nbOfCommas(lexeme) == 2) {
                if (!Dic.parseDELAF(lexeme, entryRef, lemmaRef, null, categoryRef, null, lexfeaturesRef)) continue;
                entry = (String)entryRef.argvalue;
                lemma = (String)lemmaRef.argvalue;
                category = (String)categoryRef.argvalue;
                lexfeatures = (String[])lexfeaturesRef.argvalue;
            } else if (Dic.parseDELASFeatureArray(lexeme, entryRef, categoryRef, lexfeaturesRef)) {
                entry = (String)entryRef.argvalue;
                category = (String)categoryRef.argvalue;
                lexfeatures = (String[])lexfeaturesRef.argvalue;
                lemma = entry;
            } else {
                if (!Dic.parseContracted(lexeme, entryRef, infoRef)) continue;
                entry = (String)entryRef.argvalue;
                info = (String)infoRef.argvalue;
                lemma = entry;
                category = "CONTRACTED";
                lexfeatures = new String[]{info};
            }
            if (entry == null || category == null) continue;
            ArrayList<String> headers = new ArrayList<String>();
            headers.add(entry);
            if (thereisalemma.booleanValue()) {
                headers.add(lemma);
            }
            headers.add(category);
            for (String colname : columns) {
                String featvalue = null;
                if (lexfeatures != null) {
                    for (String lexfeat : lexfeatures) {
                        if (lexfeat.equals("")) continue;
                        String lexpropname = null;
                        String lexpropvalue = null;
                        RefObject<Object> lexpropnameRef = new RefObject<Object>(lexpropname);
                        RefObject<Object> lexpropvalueRef = new RefObject<Object>(lexpropvalue);
                        Dic.getProperty(lexfeat, category, this.properties, lexpropnameRef, lexpropvalueRef);
                        lexpropname = (String)lexpropnameRef.argvalue;
                        lexpropvalue = (String)lexpropvalueRef.argvalue;
                        if (lexpropname.equals(colname)) {
                            if (featvalue == null) {
                                featvalue = lexpropvalue;
                                continue;
                            }
                            featvalue = featvalue + "+" + lexpropvalue;
                            continue;
                        }
                        if (!colname.equals("SynSem") || !lexpropname.equals(lexpropvalue)) continue;
                        featvalue = featvalue == null ? lexpropvalue : featvalue + "+" + lexpropvalue;
                    }
                }
                if (featvalue != null) {
                    headers.add(featvalue);
                    continue;
                }
                if (this.relevantProperty(category, colname)) {
                    headers.add("-");
                    continue;
                }
                headers.add(" ");
            }
            Object[] sheaders = headers.toArray(new String[headers.size()]);
            model.addRow(sheaders);
        }
        int nblexs = model.getRowCount();
        this.lblnTus.setText(Integer.toString(nblexs) + " Lexical entries:");
        for (int vColIndex = 0; vColIndex < this.table.getColumnCount(); ++vColIndex) {
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.table.getColumnModel();
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < this.table.getRowCount(); ++r) {
                renderer = this.table.getCellRenderer(r, vColIndex);
                comp = renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width + 4);
        }
        ((TableRowSorter)this.table.getRowSorter()).toggleSortOrder(0);
    }

    public boolean export(String fullname) {
        BufferedWriter sw = null;
        try {
            int i;
            sw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullname), "UTF8"));
            sw.write(this.table.getColumnName(0));
            for (i = 1; i < this.table.getColumnCount(); ++i) {
                sw.write("," + this.table.getColumnName(i));
            }
            sw.write("\n");
            for (i = 0; i < this.table.getRowCount(); ++i) {
                sw.write((String)this.table.getValueAt(i, 0));
                for (int j = 1; j < this.table.getColumnCount(); ++j) {
                    sw.write("," + (String)this.table.getValueAt(i, j));
                }
                sw.write("\n");
            }
            sw.close();
        }
        catch (IOException e) {
            try {
                sw.close();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
            return false;
        }
        return true;
    }

    public void setLblText(String s) {
        this.lblnTus.setText(s);
    }

    public JTextPane getTextPane() {
        return textPane;
    }

    public String getFullName() {
        return this.fullName;
    }

    public ErrorShell getErrorShell() {
        return this.errorShell;
    }

    public boolean isModified() {
        return this.modified;
    }

    public DictionaryEditorShell getShell() {
        return this.shell;
    }

    public JPanel getEditorPane() {
        return this.editorPane;
    }

    public JPanel getTablePane() {
        return this.tablePane;
    }

    public Language getLan() {
        return this.lan;
    }

    public static Comparator<String> getComparator() {
        return comparator;
    }

    public static Comparator<String> getComparatorInv() {
        return comparatorInv;
    }

    public JTable getTable() {
        return this.table;
    }

    public JLabel getLblnTus() {
        return this.lblnTus;
    }

    public FindReplaceDialog getFindReplaceDialog() {
        return this.findReplaceDialog;
    }

    public void setFindReplaceDialog(FindReplaceDialog findReplaceDialog) {
        this.findReplaceDialog = findReplaceDialog;
    }

    public void close() {
        if (this.modified && Launcher.projectMode) {
            int code = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Save dictionary file?", "NooJ: dictionary file has not been saved", 1);
            if (code == 2) {
                return;
            }
            if (code == 0) {
                if (this.fullName != null) {
                    this.save();
                } else {
                    this.saveAsDictionary();
                }
            }
        }
        this.shell.dispose();
        if (this.errorShell != null) {
            this.errorShell.dispose();
        }
        if (this.findReplaceDialog != null) {
            this.findReplaceDialog.dispose();
            this.setFindReplaceDialog(null);
        }
    }

    public static String getHeader(String sb) {
        StringBuilder res = new StringBuilder();
        int pos = 0;
        StringBuilder line = null;
        do {
            line = new StringBuilder();
            int i = 0;
            while (pos + i < sb.length() && sb.charAt(pos + i) != '\n') {
                line.append(sb.charAt(pos + i));
                ++i;
            }
            if (line.length() != 0 && line.charAt(0) != '#') continue;
            res.append(line + "\n");
            pos += i;
            ++pos;
        } while (line.length() == 0 || line.charAt(0) == '#');
        return res.toString();
    }

    static {
        dicComparer = null;
        dicInvComparer = null;
    }
}

